/// <reference types="svelte" />
import type { MeltActionReturn } from '../../internal/types.js';
import type { SwitchEvents } from './events.js';
import type { CreateSwitchProps } from './types.js';
export declare function createSwitch(props?: CreateSwitchProps): {
    elements: {
        root: import("../../internal/helpers/index.js").MeltElement<[{
            update: (updater: import("svelte/store").Updater<boolean>, sideEffect?: ((newValue: boolean) => void) | undefined) => void;
            set: (this: void, value: boolean) => void;
            subscribe(this: void, run: import("svelte/store").Subscriber<boolean>, invalidate?: import("svelte/store").Invalidator<boolean> | undefined): import("svelte/store").Unsubscriber;
            get: () => boolean;
            destroy?: (() => void) | undefined;
        }, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>], <Node_1 extends any>(node: HTMLElement) => MeltActionReturn<SwitchEvents['root']>, ([$checked, $disabled, $required]: [boolean, boolean, boolean]) => {
            readonly 'data-disabled': true | undefined;
            readonly disabled: true | undefined;
            readonly 'data-state': "checked" | "unchecked";
            readonly type: "button";
            readonly role: "switch";
            readonly 'aria-checked': "true" | "false";
            readonly 'aria-required': "true" | undefined;
        }, string>;
        input: import("../../internal/helpers/index.js").MeltElement<[{
            update: (updater: import("svelte/store").Updater<boolean>, sideEffect?: ((newValue: boolean) => void) | undefined) => void;
            set: (this: void, value: boolean) => void;
            subscribe(this: void, run: import("svelte/store").Subscriber<boolean>, invalidate?: import("svelte/store").Invalidator<boolean> | undefined): import("svelte/store").Unsubscriber;
            get: () => boolean;
            destroy?: (() => void) | undefined;
        }, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<string>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<string>>], import("svelte/action").Action<any, any, Record<never, any>>, ([$checked, $name, $required, $disabled, $value]: [boolean, string, boolean, boolean, string]) => {
            readonly type: "checkbox";
            readonly 'aria-hidden': true;
            readonly hidden: true;
            readonly tabindex: -1;
            readonly name: string;
            readonly value: string;
            readonly checked: boolean;
            readonly required: boolean;
            readonly disabled: true | undefined;
            readonly style: string;
        }, string>;
    };
    states: {
        checked: {
            update: (updater: import("svelte/store").Updater<boolean>, sideEffect?: ((newValue: boolean) => void) | undefined) => void;
            set: (this: void, value: boolean) => void;
            subscribe(this: void, run: import("svelte/store").Subscriber<boolean>, invalidate?: import("svelte/store").Invalidator<boolean> | undefined): import("svelte/store").Unsubscriber;
            get: () => boolean;
            destroy?: (() => void) | undefined;
        };
    };
    options: import("../../internal/helpers/index.js").ToWritableStores<Omit<{
        defaultChecked: boolean;
        checked?: import("svelte/store").Writable<boolean> | undefined;
        onCheckedChange?: import("../../internal/helpers/index.js").ChangeFn<boolean> | undefined;
        disabled: boolean;
        required: boolean;
        name: string;
        value: string;
    }, "checked">>;
};
