import { makeElement, createElHelpers, omit, overridable, toWritableStores, } from '../../internal/helpers/index.js';
import { writable } from 'svelte/store';
const defaults = {
    defaultValue: 0,
    max: 100,
};
const { name } = createElHelpers('progress');
export const createProgress = (props) => {
    const withDefaults = { ...defaults, ...props };
    const options = toWritableStores(omit(withDefaults, 'value'));
    const { max } = options;
    const valueWritable = withDefaults.value ?? writable(withDefaults.defaultValue);
    const value = overridable(valueWritable, withDefaults?.onValueChange);
    const root = makeElement(name(), {
        stores: [value, max],
        returned: ([$value, $max]) => {
            return {
                value: $value,
                max: $max,
                role: 'meter',
                'aria-valuemin': 0,
                'aria-valuemax': $max,
                'aria-valuenow': $value,
                'data-value': $value,
                'data-state': $value === null ? 'indeterminate' : $value === $max ? 'complete' : 'loading',
                'data-max': $max,
            };
        },
    });
    return {
        elements: {
            root,
        },
        states: {
            value,
        },
        options,
    };
};
