import { makeElement, toWritableStores } from '../../internal/helpers/index.js';
const defaults = {
    orientation: 'horizontal',
    decorative: false,
};
export const createSeparator = (props) => {
    const withDefaults = { ...defaults, ...props };
    const options = toWritableStores(withDefaults);
    const { orientation, decorative } = options;
    const root = makeElement('separator', {
        stores: [orientation, decorative],
        returned: ([$orientation, $decorative]) => {
            const ariaOrientation = $orientation === 'vertical' ? $orientation : undefined;
            return {
                role: $decorative ? 'none' : 'separator',
                'aria-orientation': ariaOrientation,
                'aria-hidden': $decorative,
                'data-orientation': $orientation,
            };
        },
    });
    return {
        elements: {
            root,
        },
        options,
    };
};
