/// <reference types="svelte" />
import type { MeltActionReturn } from '../../internal/types.js';
import type { ToolbarEvents } from './events.js';
import type { CreateToolbarGroupProps, CreateToolbarProps, ToolbarGroupItemProps, ToolbarGroupType } from './types.js';
export declare const createToolbar: (props?: CreateToolbarProps) => {
    elements: {
        root: import("../../internal/helpers/index.js").MeltElement<import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../../internal/types.js").Orientation>>, import("svelte/action").Action<any, any, Record<never, any>>, ($orientation: import("../../internal/types.js").Orientation) => {
            role: string;
            'data-orientation': import("../../internal/types.js").Orientation;
        }, string>;
        button: import("../../internal/helpers/index.js").MeltElement<import("svelte/store").Stores | undefined, (node: HTMLElement) => MeltActionReturn<ToolbarEvents['button']>, () => {
            readonly role: "button";
            readonly type: "button";
        }, string>;
        separator: import("../../internal/helpers/index.js").MeltElement<import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../../internal/types.js").Orientation>>, import("svelte/action").Action<any, any, Record<never, any>>, ($orientation: import("../../internal/types.js").Orientation) => {
            readonly role: "separator";
            readonly 'data-orientation': "horizontal" | "vertical";
            readonly 'aria-orientation': "horizontal" | "vertical";
        }, string>;
        link: import("../../internal/helpers/index.js").MeltElement<import("svelte/store").Stores | undefined, (node: HTMLElement) => MeltActionReturn<ToolbarEvents['link']>, () => {
            readonly role: "link";
        }, string>;
    };
    builders: {
        createToolbarGroup: <T extends ToolbarGroupType = "single">(props?: CreateToolbarGroupProps<T> | undefined) => {
            elements: {
                group: import("../../internal/helpers/index.js").MeltElement<import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../../internal/types.js").Orientation>>, import("svelte/action").Action<any, any, Record<never, any>>, ($orientation: import("../../internal/types.js").Orientation) => {
                    readonly role: "group";
                    readonly 'data-orientation': import("../../internal/types.js").Orientation;
                }, string>;
                item: import("../../internal/helpers/index.js").MeltElement<[import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<boolean>>, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<"single" | T>>, {
                    update: (updater: import("svelte/store").Updater<string | string[] | undefined>, sideEffect?: ((newValue: string | string[] | undefined) => void) | undefined) => void;
                    set: (this: void, value: string | string[] | undefined) => void;
                    subscribe(this: void, run: import("svelte/store").Subscriber<string | string[] | undefined>, invalidate?: import("svelte/store").Invalidator<string | string[] | undefined> | undefined): import("svelte/store").Unsubscriber;
                    get: () => string | string[] | undefined;
                    destroy?: (() => void) | undefined;
                }, import("../../internal/helpers/index.js").WithGet<import("svelte/store").Writable<import("../../internal/types.js").Orientation>>], (node: HTMLElement) => MeltActionReturn<ToolbarEvents['item']>, ([$disabled, $type, $value, $orientation]: [boolean, "single" | T, string | string[] | undefined, import("../../internal/types.js").Orientation]) => (props: ToolbarGroupItemProps) => {
                    readonly disabled: true | undefined;
                    readonly pressed: boolean;
                    readonly 'data-orientation': import("../../internal/types.js").Orientation;
                    readonly 'data-disabled': true | undefined;
                    readonly 'data-value': string;
                    readonly 'data-state': "on" | "off";
                    readonly 'aria-checked': boolean | undefined;
                    readonly 'aria-pressed': boolean | undefined;
                    readonly type: "button";
                    readonly role: "radio" | undefined;
                    readonly 'data-melt-toolbar-item': "";
                }, string>;
            };
            states: {
                value: {
                    update: (updater: import("svelte/store").Updater<string | string[] | undefined>, sideEffect?: ((newValue: string | string[] | undefined) => void) | undefined) => void;
                    set: (this: void, value: string | string[] | undefined) => void;
                    subscribe(this: void, run: import("svelte/store").Subscriber<string | string[] | undefined>, invalidate?: import("svelte/store").Invalidator<string | string[] | undefined> | undefined): import("svelte/store").Unsubscriber;
                    get: () => string | string[] | undefined;
                    destroy?: (() => void) | undefined;
                };
            };
            helpers: {
                isPressed: import("svelte/store").Readable<(itemValue: string) => boolean>;
            };
            options: import("../../internal/helpers/index.js").ToWritableStores<{
                defaultValue?: (T extends "single" ? string : string[]) | undefined;
                value?: import("svelte/store").Writable<string | string[] | undefined> | undefined;
                onValueChange?: import("../../internal/helpers/index.js").ChangeFn<string | string[] | undefined> | undefined;
                type: "single" | T;
                disabled: boolean;
            }>;
        };
    };
    options: import("../../internal/helpers/index.js").ToWritableStores<{
        loop: boolean;
        orientation: import("../../internal/types.js").Orientation;
    }>;
};
