import type { FloatingConfig } from '../../internal/actions/index.js';
import type { ChangeFn, IdObj } from '../../internal/helpers/index.js';
import type { BuilderReturn } from '../../internal/types.js';
import type { Writable } from 'svelte/store';
import type { TooltipIdParts, createTooltip } from './create.js';
export type { TooltipComponentEvents } from './events.js';
export type CreateTooltipProps = {
    positioning?: FloatingConfig;
    arrowSize?: number;
    defaultOpen?: boolean;
    open?: Writable<boolean>;
    onOpenChange?: ChangeFn<boolean>;
    closeOnPointerDown?: boolean;
    openDelay?: number;
    closeDelay?: number;
    forceVisible?: boolean;
    closeOnEscape?: boolean;
    disableHoverableContent?: boolean;
    /**
     * If set to `true`, whenever you open this tooltip, all other tooltips
     * with `group` also set to `true` will close. If you pass in a string
     * instead, only tooltips with the same `group` value will be closed.
     */
    group?: boolean | string;
    /**
     * If not undefined, the tooltip will be rendered within the provided element or selector.
     *
     * @default 'body'
     */
    portal?: HTMLElement | string | null;
    /**
     * Optionally override the default ids we assign to the elements
     */
    ids?: Partial<IdObj<TooltipIdParts>>;
};
export type Tooltip = BuilderReturn<typeof createTooltip>;
export type TooltipElements = Tooltip['elements'];
export type TooltipOptions = Tooltip['options'];
export type TooltipStates = Tooltip['states'];
