/// <reference types="svelte" />
import type { Writable } from 'svelte/store';
import type { CalendarDate, ZonedDateTime, CalendarDateTime, DateDuration, DateFields, DateTimeDuration, DateValue, Disambiguation, TimeFields } from '@internationalized/date';
type AnyDateTime = ZonedDateTime | CalendarDateTime;
type DerivedDuration<T> = T extends AnyDateTime ? DateTimeDuration : T extends CalendarDate ? DateDuration : never;
type DerivedFields<T> = T extends AnyDateTime ? DateFields & TimeFields : T extends CalendarDate ? DateFields : never;
/**
 * A higher order store that encapsulates a writable store holding a `DateValue` from the
 * '@internationalized/date' library. It provides some convenience methods for common
 * date manipulations.
 *
 * @see [@internationalized/date](https://react-spectrum.adobe.com/internationalized/date/index.html)
 */
export declare function dateStore<T extends DateValue>(store: Writable<T>, defaultValue: T): {
    get: () => T;
    set: (this: void, value: T) => void;
    update: (this: void, updater: import("svelte/store").Updater<T>) => void;
    subscribe: (this: void, run: import("svelte/store").Subscriber<T>, invalidate?: import("svelte/store").Invalidator<T> | undefined) => import("svelte/store").Unsubscriber;
    add: (duration: DerivedDuration<T>) => void;
    subtract: (duration: DerivedDuration<T>) => void;
    setDate: (fields: DerivedFields<T>, disambiguation?: T extends ZonedDateTime ? Disambiguation : never) => void;
    reset: () => void;
    toWritable: () => {
        set: (this: void, value: T) => void;
        subscribe: (this: void, run: import("svelte/store").Subscriber<T>, invalidate?: import("svelte/store").Invalidator<T> | undefined) => import("svelte/store").Unsubscriber;
        update: (this: void, updater: import("svelte/store").Updater<T>) => void;
        get: () => T;
    };
    nextPage: (amount: number) => void;
    prevPage: (amount: number) => void;
};
export type DateStore<T> = Writable<T> & {
    add: (duration: DerivedDuration<T>) => void;
    subtract: (duration: DerivedDuration<T>) => void;
    setDate: (fields: DerivedFields<T>, disambiguation?: T extends ZonedDateTime ? Disambiguation : never) => void;
    reset: () => void;
    nextPage: (amount: number) => void;
    prevPage: (amount: number) => void;
};
export {};
