import type { Readable, Writable } from 'svelte/store';
export declare const isBrowser: boolean;
export declare const isFunction: (v: unknown) => v is Function;
export declare const isLetter: (key: string) => boolean;
export declare function isDocument(element: unknown): element is Document;
export declare function isElement(element: unknown): element is Element;
export declare function isHTMLElement(element: unknown): element is HTMLElement;
export declare function isHTMLInputElement(element: unknown): element is HTMLInputElement;
export declare function isHTMLLabelElement(element: unknown): element is HTMLLabelElement;
export declare function isHTMLButtonElement(element: unknown): element is HTMLButtonElement;
export declare function isElementDisabled(element: HTMLElement): boolean;
export declare function isTouch(event: PointerEvent): boolean;
export declare function isLeftClick(event: PointerEvent | MouseEvent): boolean;
export declare function isFocusVisible(element: Element): boolean;
export declare function isContentEditable(element: unknown): element is HTMLElement;
export declare function isNull(value: unknown): value is null;
export declare function isNumberString(value: string): boolean;
export declare function isObject(value: unknown): value is Record<string, unknown>;
export declare function isReadable(value: unknown): value is Readable<unknown>;
export declare function isWritable(value: unknown): value is Writable<unknown>;
