/**
 * A constant object that maps commonly used keyboard keys to their corresponding string values.
 * This object can be used in other parts of the application to handle keyboard input and prevent
 * hard-coded strings throughout.
 */
export declare const kbd: {
    ALT: string;
    ARROW_DOWN: string;
    ARROW_LEFT: string;
    ARROW_RIGHT: string;
    ARROW_UP: string;
    BACKSPACE: string;
    CAPS_LOCK: string;
    CONTROL: string;
    DELETE: string;
    END: string;
    ENTER: string;
    ESCAPE: string;
    F1: string;
    F10: string;
    F11: string;
    F12: string;
    F2: string;
    F3: string;
    F4: string;
    F5: string;
    F6: string;
    F7: string;
    F8: string;
    F9: string;
    HOME: string;
    META: string;
    PAGE_DOWN: string;
    PAGE_UP: string;
    SHIFT: string;
    SPACE: string;
    TAB: string;
    CTRL: string;
    ASTERISK: string;
    A: string;
    P: string;
};
/** Key sets for navigation within lists, such as select, menu, and combobox. */
export declare const FIRST_KEYS: string[];
export declare const LAST_KEYS: string[];
export declare const FIRST_LAST_KEYS: string[];
export declare const SELECTION_KEYS: string[];
export declare const getNextKey: (dir?: 'ltr' | 'rtl', orientation?: 'horizontal' | 'vertical') => string;
export declare const getPrevKey: (dir?: 'ltr' | 'rtl', orientation?: 'horizontal' | 'vertical') => string;
export declare const getDirectionalKeys: (dir?: 'ltr' | 'rtl', orientation?: 'horizontal' | 'vertical') => {
    nextKey: string;
    prevKey: string;
};
