export declare function omit<T extends Record<string, unknown>, K extends keyof T>(obj: T, ...keys: K[]): Omit<T, K>;
type StrippedKeys<T extends Record<string, unknown>, ToStrip> = {
    [K in keyof T]: T[K] extends ToStrip ? never : K;
};
type StripValues<T extends Record<string, unknown>, ToStrip> = {
    [K in StrippedKeys<T, ToStrip>[keyof T]]: T[K];
};
type StripValuesRecursive<T extends Record<string, unknown>, ToStrip> = {
    [K in StrippedKeys<T, ToStrip>[keyof T]]: T[K] extends Record<string, unknown> ? StripValuesRecursive<T[K], ToStrip> : T[K];
};
export declare function stripValues<T extends Record<string, unknown>, ToStrip>(inputObject: T, toStrip: ToStrip, recursive: false): StripValues<T, ToStrip>;
export declare function stripValues<T extends Record<string, unknown>, ToStrip>(inputObject: T, toStrip: ToStrip, recursive: true): StripValuesRecursive<T, ToStrip>;
export declare function removeUndefined<T extends object>(obj: T): {
    [K in keyof T]-?: Exclude<T[K], undefined>;
};
export {};
