import type { HTMLAnchorAttributes, HTMLButtonAttributes } from "svelte/elements";
import type { DOMEl } from "../../internal/types.js";
import type { Builder } from "../../internal/index.js";
export type ButtonPropsWithoutHTML = {
    /**
     * Melt UI builders to apply to the button component.
     */
    builders?: Builder[] | undefined;
};
type AnchorElement = ButtonPropsWithoutHTML & HTMLAnchorAttributes & {
    href?: HTMLAnchorAttributes["href"] | undefined;
    type?: never | undefined;
} & DOMEl<HTMLAnchorElement>;
type ButtonElement = ButtonPropsWithoutHTML & HTMLButtonAttributes & {
    type?: HTMLButtonAttributes["type"] | undefined;
    href?: never | undefined;
} & DOMEl<HTMLButtonElement>;
export type ButtonProps = AnchorElement | ButtonElement;
export type ButtonEventHandler<T extends Event = Event> = T & {
    currentTarget: EventTarget & HTMLButtonElement;
};
export type ButtonEvents = {
    click: ButtonEventHandler<MouseEvent>;
    keydown: ButtonEventHandler<KeyboardEvent>;
    change: ButtonEventHandler<Event>;
    keyup: ButtonEventHandler<KeyboardEvent>;
    mouseenter: ButtonEventHandler<MouseEvent>;
    mouseleave: ButtonEventHandler<MouseEvent>;
    mousedown: ButtonEventHandler<MouseEvent>;
    mouseup: ButtonEventHandler<MouseEvent>;
    pointerdown: ButtonEventHandler<PointerEvent>;
    pointerup: ButtonEventHandler<PointerEvent>;
};
export {};
