import { createEventDispatcher } from "svelte";
export function createDispatcher() {
    const dispatch = createEventDispatcher();
    return (e) => {
        const { originalEvent } = e.detail;
        const { cancelable } = e;
        const type = originalEvent.type;
        const shouldContinue = dispatch(type, { originalEvent, currentTarget: originalEvent.currentTarget }, { cancelable });
        if (!shouldContinue) {
            e.preventDefault();
        }
    };
}
