/**
 * @license lucide-svelte v0.469.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
import { SvelteComponentTyped } from "svelte";
import type { IconProps } from '../types.js';
declare const __propDef: {
    props: IconProps;
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type DumbbellProps = typeof __propDef.props;
export type DumbbellEvents = typeof __propDef.events;
export type DumbbellSlots = typeof __propDef.slots;
/**
 * @component @name Dumbbell
 * @description Lucide SVG icon component, renders SVG Element with children.
 *
 * @preview ![img](data:image/svg+xml;base64,PHN2ZyAgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogIHdpZHRoPSIyNCIKICBoZWlnaHQ9IjI0IgogIHZpZXdCb3g9IjAgMCAyNCAyNCIKICBmaWxsPSJub25lIgogIHN0cm9rZT0iIzAwMCIgc3R5bGU9ImJhY2tncm91bmQtY29sb3I6ICNmZmY7IGJvcmRlci1yYWRpdXM6IDJweCIKICBzdHJva2Utd2lkdGg9IjIiCiAgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIgogIHN0cm9rZS1saW5lam9pbj0icm91bmQiCj4KICA8cGF0aCBkPSJNMTQuNCAxNC40IDkuNiA5LjYiIC8+CiAgPHBhdGggZD0iTTE4LjY1NyAyMS40ODVhMiAyIDAgMSAxLTIuODI5LTIuODI4bC0xLjc2NyAxLjc2OGEyIDIgMCAxIDEtMi44MjktMi44MjlsNi4zNjQtNi4zNjRhMiAyIDAgMSAxIDIuODI5IDIuODI5bC0xLjc2OCAxLjc2N2EyIDIgMCAxIDEgMi44MjggMi44Mjl6IiAvPgogIDxwYXRoIGQ9Im0yMS41IDIxLjUtMS40LTEuNCIgLz4KICA8cGF0aCBkPSJNMy45IDMuOSAyLjUgMi41IiAvPgogIDxwYXRoIGQ9Ik02LjQwNCAxMi43NjhhMiAyIDAgMSAxLTIuODI5LTIuODI5bDEuNzY4LTEuNzY3YTIgMiAwIDEgMS0yLjgyOC0yLjgyOWwyLjgyOC0yLjgyOGEyIDIgMCAxIDEgMi44MjkgMi44MjhsMS43NjctMS43NjhhMiAyIDAgMSAxIDIuODI5IDIuODI5eiIgLz4KPC9zdmc+Cg==) - https://lucide.dev/icons/dumbbell
 * @see https://lucide.dev/guide/packages/lucide-svelte - Documentation
 *
 * @param {Object} props - Lucide icons props and any valid SVG attribute
 * @returns {FunctionalComponent} Svelte component
 *
 */
export default class Dumbbell extends SvelteComponentTyped<DumbbellProps, DumbbellEvents, DumbbellSlots> {
}
export {};
