import { b as push, l as store_get, c as copy_payload, a as assign_payload, u as unsubscribe_stores, p as pop, i as ensure_array_like, e as escape_html, j as attr, k as stringify } from './hooks.server-Cdp_u6bz.js';
import './index2-C5rUfUC6.js';
import { F as Fa } from './fa-DW9dGsKW.js';
import { faArrowLeft, faCoins, faClock, faRotateRight } from '@fortawesome/free-solid-svg-icons';
import 'canvas-confetti';
import './score-Copg0mmy.js';
import { f as feedbackStore, G as GameFeedbackModal } from './GameFeedbackModal-9rhfHC9a.js';
import { B as Button } from './button-Yx-mzQxC.js';
import './index3-CjZb0xuH.js';
import './sessionStore-Cvw8bcEM.js';
import '@fortawesome/free-regular-svg-icons';
import './textarea-27hu-K-k.js';

function _page($$payload, $$props) {
  push();
  var $$store_subs;
  let cards = [];
  let timer = 0;
  let scoreIndicators = [];
  let currentScore = 0;
  let isPaused = false;
  let showFeedback = false;
  let currentRound = store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound;
  function handleGamePause() {
    console.log("⏸️ Game paused");
    isPaused = true;
  }
  if (store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound !== currentRound) {
    currentRound = store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound;
    console.log("🔄 Round updated from store:", currentRound);
  }
  if (store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound % 2 === 1 && !showFeedback && !feedbackStore.isFeedbackShown(store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound)) {
    console.log("📝 Setting up feedback delay after round change", store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound);
    setTimeout(
      () => {
        console.log("📝 Showing feedback for round", store_get($$store_subs ??= {}, "$feedbackStore", feedbackStore).currentRound);
        handleGamePause();
        showFeedback = true;
      },
      2e3
    );
  }
  let $$settled = true;
  let $$inner_payload;
  function $$render_inner($$payload2) {
    const each_array = ensure_array_like(scoreIndicators);
    const each_array_1 = ensure_array_like(cards);
    $$payload2.out += `<div class="h-full flex flex-col"><header class="flex justify-between items-center h-14 px-6 mb-4 bg-gradient-to-r bg-orange-600/10 backdrop-blur-sm border-b border-orange-500/20 rounded-lg"><div class="flex items-center gap-6"><a href="/" class="flex items-center justify-center w-8 h-8 rounded-full hover:bg-orange-500/20 transition-colors">`;
    Fa($$payload2, { icon: faArrowLeft, class: "text-lg" });
    $$payload2.out += `<!----></a> <h1 class="text-xl font-bold tracking-tight">Pick the Pairs</h1></div> <div class="flex items-center gap-6"><div class="flex items-center gap-2 bg-orange-500/10 px-4 py-2 rounded-lg">`;
    Fa($$payload2, { icon: faCoins, class: "text-orange-400" });
    $$payload2.out += `<!----> <span class="font-medium">${escape_html(currentScore)}</span></div> <div class="flex items-center gap-2 bg-orange-500/10 px-4 py-2 rounded-lg">`;
    Fa($$payload2, { icon: faClock, class: "text-orange-400" });
    $$payload2.out += `<!----> <span class="font-medium">${escape_html(Math.floor(timer / 60))}:${escape_html((timer % 60).toString().padStart(2, "0"))}</span></div> <div class="w-px h-8 bg-orange-500/20"></div> `;
    Button($$payload2, {
      variant: "ghost",
      size: "icon",
      class: "w-8 h-8 rounded-full hover:bg-orange-500/20",
      children: ($$payload3) => {
        Fa($$payload3, { icon: faRotateRight });
      },
      $$slots: { default: true }
    });
    $$payload2.out += `<!----></div></header> <main class="flex-1 p-2 flex items-center justify-center min-h-0"><div class="relative w-full max-w-4xl mx-auto"><!--[-->`;
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let indicator = each_array[$$index];
      $$payload2.out += `<div class="absolute pointer-events-none z-50"${attr("style", ` left: ${stringify(indicator.x)}px; top: ${stringify(indicator.y)}px; transform: translate(-50%, -50%) scale(${stringify(indicator.scale)}); opacity: ${stringify(indicator.opacity)}; `)}>`;
      if (indicator.text) {
        $$payload2.out += "<!--[-->";
        $$payload2.out += `<div${attr("class", `text-2xl font-bold ${stringify(indicator.color)} drop-shadow-lg svelte-ojigp7`)}>${escape_html(indicator.text)}</div>`;
      } else {
        $$payload2.out += "<!--[!-->";
        $$payload2.out += `<div class="text-3xl font-bold text-red-400 drop-shadow-lg">✕</div>`;
      }
      $$payload2.out += `<!--]--></div>`;
    }
    $$payload2.out += `<!--]--> <div class="grid grid-cols-4 gap-2 w-full aspect-[4/3]"><!--[-->`;
    for (let index = 0, $$length = each_array_1.length; index < $$length; index++) {
      let card = each_array_1[index];
      $$payload2.out += `<button${attr("class", `relative w-full h-full ${stringify([
        isPaused ? "pointer-events-none" : ""
      ].filter(Boolean).join(" "))}`)}><div${attr("class", `absolute inset-0 w-full h-full transition-transform duration-500 transform-style-3d ${stringify(card.isFlipped || card.isMatched ? "rotate-y-180" : "")} svelte-ojigp7`)}><div class="absolute inset-0 w-full h-full backface-hidden bg-zinc-900 rounded-lg border bg-black/65 dark:bg-black/50 svelte-ojigp7"><img src="/images/logos/porsche-logo.png" alt="Card back" class="w-full h-full object-contain p-6"></div> <div${attr("class", `absolute inset-0 w-full h-full backface-hidden rotate-y-180 bg-white rounded-lg border border-zinc-200 dark:border-zinc-800 overflow-hidden ${stringify(card.isMatched ? "opacity-60" : "")} svelte-ojigp7`)}><div class="w-full h-full p-2"><img${attr("src", card.image)} alt="Car" class="w-full h-full object-contain bg-white rounded-lg"></div></div></div></button>`;
    }
    $$payload2.out += `<!--]--></div></div></main></div> `;
    GameFeedbackModal($$payload2);
    $$payload2.out += `<!----> `;
    {
      $$payload2.out += "<!--[!-->";
    }
    $$payload2.out += `<!--]-->`;
  }
  do {
    $$settled = true;
    $$inner_payload = copy_payload($$payload);
    $$render_inner($$inner_payload);
  } while (!$$settled);
  assign_payload($$payload, $$inner_payload);
  if ($$store_subs) unsubscribe_stores($$store_subs);
  pop();
}

export { _page as default };
//# sourceMappingURL=_page.svelte-AwK16J3-.js.map
