import { b as push, c as copy_payload, a as assign_payload, p as pop, j as attr, k as stringify, f as bind_props } from './hooks.server-Cdp_u6bz.js';
import './index2-C5rUfUC6.js';
import { L as Label, I as Input } from './label-DnWJ7cdR.js';
import { T as fallback } from './index3-CjZb0xuH.js';
import { F as Fa } from './fa-DW9dGsKW.js';
import { faCar, faWrench, faTimes, faUpload } from '@fortawesome/free-solid-svg-icons';
import { B as Button } from './button-Yx-mzQxC.js';

function Brand_modal($$payload, $$props) {
  push();
  let show = fallback($$props["show"], false);
  let brandName = "";
  let isUploading = false;
  let $$settled = true;
  let $$inner_payload;
  function $$render_inner($$payload2) {
    if (show) {
      $$payload2.out += "<!--[-->";
      $$payload2.out += `<div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50"><div class="bg-[#1a1a1a] p-6 rounded-lg w-full max-w-lg mx-4"><div class="flex justify-between items-center mb-4"><h3 class="text-lg font-semibold">Shto Markë të Re</h3> <button class="text-gray-400 hover:text-white">`;
      Fa($$payload2, { icon: faTimes });
      $$payload2.out += `<!----></button></div> <div class="space-y-4">`;
      {
        $$payload2.out += "<!--[!-->";
      }
      $$payload2.out += `<!--]--> <div>`;
      Label($$payload2, {
        for: "brandName",
        children: ($$payload3) => {
          $$payload3.out += `<!---->Emri i Markës`;
        },
        $$slots: { default: true }
      });
      $$payload2.out += `<!----> `;
      Input($$payload2, {
        id: "brandName",
        placeholder: "p.sh. Volkswagen",
        class: "bg-[#252525] border-gray-800 focus:border-[#ff6b00]",
        get value() {
          return brandName;
        },
        set value($$value) {
          brandName = $$value;
          $$settled = false;
        }
      });
      $$payload2.out += `<!----></div> <div>`;
      Label($$payload2, {
        children: ($$payload3) => {
          $$payload3.out += `<!---->Logo e Markës`;
        },
        $$slots: { default: true }
      });
      $$payload2.out += `<!----> <div${attr("class", `mt-2 border-2 border-dashed border-gray-800 hover:border-[#ff6b00]/50 transition-colors rounded-lg p-4 text-center ${stringify([""].filter(Boolean).join(" "))}`)}>`;
      {
        $$payload2.out += "<!--[!-->";
        $$payload2.out += `<label class="cursor-pointer block"><input type="file" accept="image/*" class="hidden"> <div class="flex flex-col items-center gap-2">`;
        Fa($$payload2, {
          icon: faUpload,
          size: "2x",
          class: "text-gray-500"
        });
        $$payload2.out += `<!----> <span class="text-sm text-gray-500">`;
        {
          $$payload2.out += "<!--[!-->";
          $$payload2.out += `Kliko për të ngarkuar logon`;
        }
        $$payload2.out += `<!--]--></span></div></label>`;
      }
      $$payload2.out += `<!--]--></div></div> <div class="flex justify-end gap-2 pt-4">`;
      Button($$payload2, {
        variant: "outline",
        class: "border-gray-800 hover:bg-[#252525]",
        children: ($$payload3) => {
          $$payload3.out += `<!---->Anulo`;
        },
        $$slots: { default: true }
      });
      $$payload2.out += `<!----> `;
      Button($$payload2, {
        class: "bg-[#ff6b00] hover:bg-[#ff6b00]/90",
        disabled: isUploading,
        children: ($$payload3) => {
          $$payload3.out += `<!---->Shto`;
        },
        $$slots: { default: true }
      });
      $$payload2.out += `<!----></div></div></div></div>`;
    } else {
      $$payload2.out += "<!--[!-->";
    }
    $$payload2.out += `<!--]-->`;
  }
  do {
    $$settled = true;
    $$inner_payload = copy_payload($$payload);
    $$render_inner($$inner_payload);
  } while (!$$settled);
  assign_payload($$payload, $$inner_payload);
  bind_props($$props, { show });
  pop();
}
function _page($$payload, $$props) {
  push();
  let showBrandModal = false;
  let brands = [];
  const fetchBrandsWithImages = async () => {
    try {
      const response = await fetch("/api/brands");
      if (response.ok) {
        const brandsData = await response.json();
        brands = brandsData.map((brand) => ({
          ...brand,
          imagePath: `/images/brands/${brand.id}.png`
          // Assuming image path follows this pattern
        }));
      } else {
        console.error("Error fetching brands:", response.statusText);
      }
    } catch (error) {
      console.error("Error during fetching brands:", error);
    }
  };
  fetchBrandsWithImages();
  let $$settled = true;
  let $$inner_payload;
  function $$render_inner($$payload2) {
    $$payload2.out += `<div class="min-h-screen bg-[#11111111] text-white p-4 overflow-y-auto"><div class="max-w-2xl mx-auto"><header class="mb-8"><h1 class="text-2xl font-bold mb-2">Formulari i Feedback-ut</h1> <p class="text-gray-400 mb-6">Çfarë shërbimi po prisni?</p></header> <div class="grid grid-cols-2 gap-4 mb-4"><button${attr("class", `p-4 rounded-lg flex flex-row items-center justify-center gap-4 border-2 transition-colors ${stringify("border-gray-800 hover:border-[#ff6b00]/50 bg-[#252525]")}`)}>`;
    Fa($$payload2, { icon: faCar, size: "2x" });
    $$payload2.out += `<!----> <span class="font-medium text-left">Shitje<br><span class="text-sm text-gray-400">Modifiko pyetjet e formit te shitjes</span></span></button> <button${attr("class", `p-6 rounded-lg flex flex-row items-center justify-center gap-3 border-2 transition-colors ${stringify("border-gray-800 hover:border-[#ff6b00]/50 bg-[#252525]")}`)}>`;
    Fa($$payload2, { icon: faWrench, size: "2x" });
    $$payload2.out += `<!----> <span class="font-medium text-left">Servis<br><span class="text-sm text-gray-400">Modifiko pyetjet e formit te servisit</span></span></button></div> `;
    {
      $$payload2.out += "<!--[!-->";
    }
    $$payload2.out += `<!--]--></div></div> `;
    Brand_modal($$payload2, {
      get show() {
        return showBrandModal;
      },
      set show($$value) {
        showBrandModal = $$value;
        $$settled = false;
      }
    });
    $$payload2.out += `<!----> `;
    {
      $$payload2.out += "<!--[!-->";
    }
    $$payload2.out += `<!--]-->`;
  }
  do {
    $$settled = true;
    $$inner_payload = copy_payload($$payload);
    $$render_inner($$inner_payload);
  } while (!$$settled);
  assign_payload($$payload, $$inner_payload);
  pop();
}

export { _page as default };
//# sourceMappingURL=_page.svelte-DvsCsH0t.js.map
