import { b as push, i as ensure_array_like, j as attr, k as stringify, e as escape_html, p as pop } from './hooks.server-Cdp_u6bz.js';
import './index2-C5rUfUC6.js';
import { B as Button } from './button-Yx-mzQxC.js';
import './index3-CjZb0xuH.js';

function _page($$payload, $$props) {
  push();
  let leaderboardData = [];
  let currentUsername = "";
  async function getDataFromApi() {
    const response = await fetch("/api/clients");
    const data = await response.json();
    leaderboardData = data.map((client) => {
      return {
        id: client.id,
        username: client.username,
        totalScore: client.totalPoints || 0,
        gamesPlayed: client.totalRounds || 0,
        lastPlayed: new Date(client.lastPlayed || Date.now())
      };
    }).sort((a, b) => b.totalScore - a.totalScore);
  }
  function loadLeaderboard() {
    getDataFromApi().then((data) => {
      return data.filter((data2) => {
        return true;
      }).sort((a, b) => b.totalScore - a.totalScore);
    });
  }
  function getMedalIcon(index) {
    switch (index) {
      case 0:
        return "🥇";
      case 1:
        return "🥈";
      case 2:
        return "🥉";
      default:
        return "";
    }
  }
  {
    loadLeaderboard();
  }
  $$payload.out += `<div class="min-h-screen bg-background p-4 md:p-8"><div class="max-w-4xl mx-auto"><div class="text-center mb-8"><h1 class="text-4xl font-bold text-foreground mb-3">Tabela e Pikëve</h1> <p class="text-gray-400">Shikoni lojtarët më të mirë dhe arritjet e tyre</p></div> <div class="bg-card/50 backdrop-blur-lg rounded-xl p-4 mb-6"><div class="flex flex-wrap gap-2">`;
  Button($$payload, {
    variant: "default",
    class: "bg-orange-500 hover:bg-orange-600",
    children: ($$payload2) => {
      $$payload2.out += `<!---->Gjithë koha`;
    },
    $$slots: { default: true }
  });
  $$payload.out += `<!----> `;
  Button($$payload, {
    variant: "outline",
    class: "",
    children: ($$payload2) => {
      $$payload2.out += `<!---->Sot`;
    },
    $$slots: { default: true }
  });
  $$payload.out += `<!----> `;
  Button($$payload, {
    variant: "outline",
    class: "",
    children: ($$payload2) => {
      $$payload2.out += `<!---->Java`;
    },
    $$slots: { default: true }
  });
  $$payload.out += `<!----> `;
  Button($$payload, {
    variant: "outline",
    class: "",
    children: ($$payload2) => {
      $$payload2.out += `<!---->Muaji`;
    },
    $$slots: { default: true }
  });
  $$payload.out += `<!----></div></div> <div class="bg-card/50 backdrop-blur-lg rounded-xl overflow-hidden">`;
  if (leaderboardData.length === 0) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<div class="p-8 text-center text-gray-400">Nuk ka të dhëna për këtë periudhë</div>`;
  } else {
    $$payload.out += "<!--[!-->";
    const each_array = ensure_array_like(leaderboardData);
    $$payload.out += `<div class="overflow-x-auto"><table class="w-full"><thead><tr class="border-b border-orange-500/20"><th class="px-6 py-4 text-left text-sm font-medium text-foreground">Pozicioni</th><th class="px-6 py-4 text-left text-sm font-medium text-foreground">Lojtari</th><th class="px-6 py-4 text-center text-sm font-medium text-foreground">Pikët</th><th class="px-6 py-4 text-center text-sm font-medium text-foreground">Lojëra</th><th class="px-6 py-4 text-center text-sm font-medium text-foreground">Luajtur ne date</th></tr></thead><tbody><!--[-->`;
    for (let index = 0, $$length = each_array.length; index < $$length; index++) {
      let player = each_array[index];
      $$payload.out += `<tr${attr("class", `border-b border-orange-500/20 hover:bg-orange-950/20 ${stringify(player.username === currentUsername ? "bg-orange-500/10" : "")} hover:bg-muted-background/20 transition-colors`)}><td class="px-6 py-4"><div class="flex items-center gap-2">`;
      if (index === 0 || index === 1 || index === 2) {
        $$payload.out += "<!--[-->";
        $$payload.out += `<span class="text-2xl">${escape_html(getMedalIcon(index))}</span>`;
      } else {
        $$payload.out += "<!--[!-->";
        $$payload.out += `<span class="font-medium text-foreground">#${escape_html(index + 1)}</span>`;
      }
      $$payload.out += `<!--]--></div></td><td class="px-6 py-4"><span class="font-medium text-foreground">${escape_html(player.username)}</span></td><td class="px-6 py-4 text-center"><span class="font-medium text-orange-500">${escape_html(player.totalScore.toLocaleString())}</span></td><td class="px-6 py-4 text-center"><span class="text-foreground">${escape_html(player.gamesPlayed)}</span></td><td class="px-6 py-4 text-center"><span class="text-foreground">${escape_html(player.lastPlayed.toLocaleDateString())}</span></td></tr>`;
    }
    $$payload.out += `<!--]--></tbody></table></div>`;
  }
  $$payload.out += `<!--]--></div></div></div>`;
  pop();
}

export { _page as default };
//# sourceMappingURL=_page.svelte-PwJJDsUG.js.map
