import { j as json } from './index-BIAFQWR9.js';
import { _ as _defaultExports } from './default-B08HTHG-.js';
import 'os';
import 'tty';
import 'fs';
import 'path';
import 'crypto';
import 'child_process';
import 'fs/promises';
import 'util';
import 'async_hooks';
import 'events';

const prisma = new _defaultExports.PrismaClient();
const GET = async ({ params }) => {
  const { id } = params;
  try {
    const existingResponse = await prisma.response.findUnique({
      where: { id }
      // Find the response by ID
    });
    if (existingResponse) {
      return json(existingResponse);
    } else {
      return json({ message: "Response not found" }, { status: 404 });
    }
  } catch (error) {
    console.error("Error fetching existing response:", error);
    return json({ message: "Error fetching existing response", error: error.message }, { status: 500 });
  }
};
const PATCH = async ({ request, params }) => {
  const { id } = params;
  const { value, createdAt } = await request.json();
  try {
    const updatedResponse = await prisma.response.update({
      where: { id },
      // Find the response by ID
      data: { value, createdAt }
      // Update the value
    });
    return json(updatedResponse, { status: 200 });
  } catch (error) {
    console.error("Error updating response:", error);
    return json({ error: "Failed to update response" }, { status: 500 });
  }
};

export { GET, PATCH };
//# sourceMappingURL=_server-BTOLgCgl.js.map
