import { j as json } from './index-BIAFQWR9.js';
import { _ as _defaultExports } from './default-B08HTHG-.js';
import { s as sessionManager } from './sessionStore-Cvw8bcEM.js';
import 'os';
import 'tty';
import 'fs';
import 'path';
import 'crypto';
import 'child_process';
import 'fs/promises';
import 'util';
import 'async_hooks';
import 'events';
import './index3-CjZb0xuH.js';

const prisma = new _defaultExports.PrismaClient();
const POST = async ({ request }) => {
  const { username } = await request.json();
  let client = await prisma.client.findUnique({
    where: { username }
  });
  if (client) {
    sessionManager.startSession(client);
    return json(client);
  } else {
    client = await prisma.client.create({
      data: {
        username,
        totalPoints: 0,
        // Default values
        totalRounds: 0,
        themePreference: "dark"
        // Default preference
      }
    });
    sessionManager.startSession(client);
    return json(client);
  }
};

export { POST };
//# sourceMappingURL=_server-CVxKghyr.js.map
