import { j as json } from './index-BIAFQWR9.js';
import { _ as _defaultExports } from './default-B08HTHG-.js';
import bcrypt from 'bcrypt';
import 'os';
import 'tty';
import 'fs';
import 'path';
import 'crypto';
import 'child_process';
import 'fs/promises';
import 'util';
import 'async_hooks';
import 'events';

const prisma = new _defaultExports.PrismaClient();
const GET = async () => {
  const admins = await prisma.admin.findMany();
  return json(admins);
};
const POST = async ({ request }) => {
  const { username, password, phoneNumber, email, role, privileges } = await request.json();
  const hashedPassword = await bcrypt.hash(password, 10);
  const newAdmin = await prisma.admin.create({
    data: {
      username,
      password: hashedPassword,
      // Store the hashed password
      phoneNumber,
      email,
      role,
      privileges
    }
  });
  return json(newAdmin, { status: 201 });
};

export { GET, POST };
//# sourceMappingURL=_server-DBGQAILm.js.map
