import { j as json } from './index-BIAFQWR9.js';
import { _ as _defaultExports } from './default-B08HTHG-.js';
import 'os';
import 'tty';
import 'fs';
import 'path';
import 'crypto';
import 'child_process';
import 'fs/promises';
import 'util';
import 'async_hooks';
import 'events';

const prisma = new _defaultExports.PrismaClient();
const GET = async ({ params }) => {
  const { department } = params;
  try {
    const form = await prisma.form.findUnique({
      where: { department },
      include: { questions: true, brands: true }
      // Include related data if needed
    });
    if (!form) {
      return json({ message: "Form not found" }, { status: 404 });
    }
    return json(form, { status: 200 });
  } catch (error) {
    console.error("Error retrieving form:", error);
    return json({ message: "Internal Error", error: error.message }, { status: 500 });
  }
};
const PUT = async ({ params, request }) => {
  const { department } = params;
  const { brands, questions } = await request.json();
  try {
    const existingBrands = await prisma.brand.findMany({
      where: {
        id: { in: brands }
      }
    });
    if (existingBrands.length !== brands.length) {
      return json({ message: "One or more brands not found" }, { status: 404 });
    }
    const currentForm = await prisma.form.findUnique({
      where: { department },
      include: { questions: true, brands: true }
    });
    if (!currentForm) {
      return json({ message: "Form not found" }, { status: 404 });
    }
    const newForm = await prisma.form.create({
      data: {
        department: currentForm.department,
        brands: {
          connect: existingBrands.map((brand) => ({ id: brand.id }))
        },
        questions: {
          create: currentForm.questions.map((question) => ({
            text: question.text,
            order: question.order,
            type: question.type,
            version: question.version + 1
            // Increment version for existing questions
          }))
        },
        version: currentForm.version + 1
        // Increment the form version
      }
    });
    await prisma.question.deleteMany({
      where: {
        formId: newForm.id
      }
    });
    await prisma.question.createMany({
      data: questions.map((question) => ({
        text: question.text,
        order: question.order,
        type: question.type,
        formId: newForm.id,
        version: 1
        // New questions start at version 1
      }))
    });
    return json(newForm, { status: 200 });
  } catch (error) {
    console.error("Error updating form:", error);
    return json({ message: "Internal Error", error: error.message }, { status: 500 });
  }
};

export { GET, PUT };
//# sourceMappingURL=_server-DOb-2l8S.js.map
