import { j as json } from './index-BIAFQWR9.js';
import { _ as _defaultExports } from './default-B08HTHG-.js';
import 'os';
import 'tty';
import 'fs';
import 'path';
import 'crypto';
import 'child_process';
import 'fs/promises';
import 'util';
import 'async_hooks';
import 'events';

const prisma = new _defaultExports.PrismaClient();
const GET = async () => {
  try {
    const existingResponses = await prisma.response.findMany();
    return json(existingResponses);
  } catch (error) {
    console.error("Error fetching existing responses:", error);
    return json({ message: "Error fetching existing responses", error: error.message }, { status: 500 });
  }
};
const POST = async ({ request }) => {
  const { brandId, clientId, questionId, value } = await request.json();
  try {
    const clientExists = await prisma.client.findUnique({ where: { id: clientId } });
    const brandExists = await prisma.brand.findUnique({ where: { id: brandId } });
    const questionExists = await prisma.question.findUnique({ where: { id: questionId } });
    console.log("Client Exists:", clientExists);
    console.log("Brand Exists:", brandExists);
    console.log("Question Exists:", questionExists);
    if (!clientExists || !brandExists || !questionExists) {
      return json({ error: "One or more foreign keys do not exist" }, { status: 400 });
    }
    const response = await prisma.response.create({
      data: {
        questionId,
        clientId,
        brandId,
        value
      }
    });
    return json(response, { status: 201 });
  } catch (error) {
    console.error("Error saving response:", error);
    return json({ error: "Failed to save response" }, { status: 500 });
  }
};

export { GET, POST };
//# sourceMappingURL=_server-DmHy-AgG.js.map
