import { _ as _defaultExports } from './default-B08HTHG-.js';
import { j as json } from './index-BIAFQWR9.js';
import 'os';
import 'tty';
import 'fs';
import 'path';
import 'crypto';
import 'child_process';
import 'fs/promises';
import 'util';
import 'async_hooks';
import 'events';

const prisma = new _defaultExports.PrismaClient();
const PATCH = async ({ request, params }) => {
  const { id } = params;
  const updatedQuestion = await request.json();
  try {
    const question = await prisma.question.update({
      where: { id },
      data: {
        ...updatedQuestion,
        updatedAt: /* @__PURE__ */ new Date()
      }
    });
    return json(question);
  } catch (error) {
    console.error("Error updating question:", error);
    return json({ message: "Question not found or could not be updated" }, { status: 404 });
  }
};
const DELETE = async ({ params }) => {
  const { id } = params;
  try {
    const question = await prisma.question.findUnique({
      where: { id }
    });
    if (!question) {
      return json({ message: `Question ${id} not found` }, { status: 404 });
    }
    await prisma.response.deleteMany({
      where: { questionId: id }
    });
    await prisma.question.delete({
      where: { id }
    });
    return json({ message: `Question ${id} deleted` });
  } catch (error) {
    console.error(`Error deleting question ${id}:`, error);
    return json({ message: `Question ${id} could not be deleted`, error: error.message }, { status: 500 });
  }
};

export { DELETE, PATCH };
//# sourceMappingURL=_server-DwYr9ZRN.js.map
