import { j as json } from './index-BIAFQWR9.js';
import { _ as _defaultExports } from './default-B08HTHG-.js';
import bcrypt from 'bcrypt';
import jwt from 'jsonwebtoken';
import 'os';
import 'tty';
import 'fs';
import 'path';
import 'crypto';
import 'child_process';
import 'fs/promises';
import 'util';
import 'async_hooks';
import 'events';

const prisma = new _defaultExports.PrismaClient();
const POST = async ({ request }) => {
  try {
    const { login, password } = await request.json();
    console.log(`Admin login attempt: ${JSON.stringify({ login, password })}`);
    const admin = await prisma.admin.findFirst({
      where: {
        OR: [
          { username: login },
          { email: login }
        ]
      }
    });
    if (!admin) {
      return json({ message: "Invalid login information" }, { status: 401 });
    }
    if (!await verifyPassword(password, admin.password)) {
      return json({ message: "Invalid login information" }, { status: 401 });
    }
    const token = jwt.sign({
      id: admin.id,
      username: admin.username,
      email: admin.email,
      role: admin.role
    }, process.env.JWT_SECRET, {
      expiresIn: "2h"
    });
    return json({
      message: "Login successful",
      token,
      // Return the JWT token
      user: {
        id: admin.id,
        username: admin.username,
        email: admin.email,
        role: admin.role
      }
    });
  } catch (error) {
    console.error("Error during admin login:", error);
    return json({ message: "Internal server error" }, { status: 500 });
  }
};
const verifyPassword = async (password, hash) => {
  return await bcrypt.compare(password, hash);
};

export { POST };
//# sourceMappingURL=_server-EeJ1gybp.js.map
