import { _ as _defaultExports } from './default-B08HTHG-.js';
import { j as json } from './index-BIAFQWR9.js';
import 'os';
import 'tty';
import 'fs';
import 'path';
import 'crypto';
import 'child_process';
import 'fs/promises';
import 'util';
import 'async_hooks';
import 'events';

const prisma = new _defaultExports.PrismaClient();
async function GET() {
  try {
    const brands = await prisma.brand.findMany({
      where: {
        isActive: true
        // Only fetch active brands
      }
    });
    return new Response(JSON.stringify(brands), {
      status: 200,
      headers: {
        "Content-Type": "application/json"
      }
    });
  } catch (error) {
    console.error("Error fetching brands:", error);
    return new Response("Error fetching brands", { status: 500 });
  } finally {
    await prisma.$disconnect();
  }
}
const POST = async ({ request }) => {
  const { name, imageUrl } = await request.json();
  try {
    const brand = await prisma.brand.create({
      data: {
        name,
        imageUrl
      }
    });
    return json(brand, { status: 201 });
  } catch (error) {
    console.error("Error creating brand:", error);
    return json({ error: "Failed to create brand" }, { status: 500 });
  }
};

export { GET, POST };
//# sourceMappingURL=_server-KjUC9vtQ.js.map
