import { _ as _defaultExports } from './default-B08HTHG-.js';
import { j as json } from './index-BIAFQWR9.js';
import 'os';
import 'tty';
import 'fs';
import 'path';
import 'crypto';
import 'child_process';
import 'fs/promises';
import 'util';
import 'async_hooks';
import 'events';

const prisma = new _defaultExports.PrismaClient();
const PATCH = async ({ request }) => {
  const questions = await request.json();
  try {
    const updatePromises = questions.map(
      (question) => prisma.question.update({
        where: { id: question.id },
        data: { order: question.order }
      })
    );
    await Promise.all(updatePromises);
    return json({ message: "Questions reordered successfully" });
  } catch (error) {
    console.error("Error reordering questions:", error);
    return json({ message: "Could not reorder questions", error: error.message }, { status: 500 });
  }
};

export { PATCH };
//# sourceMappingURL=_server-YdqMDmPV.js.map
