import { b as push, j as attr, k as stringify, e as escape_html, f as bind_props, p as pop } from './hooks.server-Cdp_u6bz.js';
import { T as fallback } from './index3-CjZb0xuH.js';

function getTransform(scale, translateX, translateY, rotate, flip, translateTimes = 1, translateUnit = "", rotateUnit = "") {
  let flipX = 1;
  let flipY = 1;
  if (flip) {
    if (flip == "horizontal") {
      flipX = -1;
    } else if (flip == "vertical") {
      flipY = -1;
    } else {
      flipX = flipY = -1;
    }
  }
  if (typeof scale === "string") {
    scale = parseFloat(scale);
  }
  if (typeof translateX === "string") {
    translateX = parseFloat(translateX);
  }
  if (typeof translateY === "string") {
    translateY = parseFloat(translateY);
  }
  const x = `${translateX * translateTimes}${translateUnit}`;
  const y = `${translateY * translateTimes}${translateUnit}`;
  let output = `translate(${x},${y}) scale(${flipX * scale},${flipY * scale})`;
  if (rotate) {
    output += ` rotate(${rotate}${rotateUnit})`;
  }
  return output;
}
function Fa($$payload, $$props) {
  push();
  let i, transform;
  let clazz = fallback($$props["class"], () => void 0, true);
  let id = fallback($$props["id"], () => void 0, true);
  let style = fallback($$props["style"], () => void 0, true);
  let icon = $$props["icon"];
  let title = fallback($$props["title"], () => void 0, true);
  let size = fallback($$props["size"], () => void 0, true);
  let color = fallback($$props["color"], () => void 0, true);
  let fw = fallback($$props["fw"], false);
  let pull = fallback($$props["pull"], () => void 0, true);
  let scale = fallback($$props["scale"], 1);
  let translateX = fallback($$props["translateX"], 0);
  let translateY = fallback($$props["translateY"], 0);
  let rotate = fallback($$props["rotate"], () => void 0, true);
  let flip = fallback($$props["flip"], () => void 0, true);
  let spin = fallback($$props["spin"], false);
  let pulse = fallback($$props["pulse"], false);
  let primaryColor = fallback($$props["primaryColor"], "");
  let secondaryColor = fallback($$props["secondaryColor"], "");
  let primaryOpacity = fallback($$props["primaryOpacity"], 1);
  let secondaryOpacity = fallback($$props["secondaryOpacity"], 0.4);
  let swapOpacity = fallback($$props["swapOpacity"], false);
  i = icon && icon.icon || [0, 0, "", [], ""];
  transform = getTransform(scale, translateX, translateY, rotate, flip, 512);
  if (i[4]) {
    $$payload.out += "<!--[-->";
    $$payload.out += `<svg${attr("id", id)}${attr("class", `svelte-fa svelte-fa-base ${stringify(clazz)} svelte-bvo74f ${stringify([
      pulse ? "pulse" : "",
      size === "lg" ? "svelte-fa-size-lg" : "",
      size === "sm" ? "svelte-fa-size-sm" : "",
      size === "xs" ? "svelte-fa-size-xs" : "",
      fw ? "svelte-fa-fw" : "",
      pull === "left" ? "svelte-fa-pull-left" : "",
      pull === "right" ? "svelte-fa-pull-right" : "",
      spin ? "spin" : ""
    ].filter(Boolean).join(" "))}`)}${attr("style", style)}${attr("viewBox", `0 0 ${stringify(i[0])} ${stringify(i[1])}`)} aria-hidden="true" role="img" xmlns="http://www.w3.org/2000/svg">`;
    if (title) {
      $$payload.out += "<!--[-->";
      $$payload.out += `<title class="svelte-bvo74f">${escape_html(title)}</title>`;
    } else {
      $$payload.out += "<!--[!-->";
    }
    $$payload.out += `<!--]--><g${attr("transform", `translate(${stringify(i[0] / 2)} ${stringify(i[1] / 2)})`)}${attr("transform-origin", `${stringify(i[0] / 4)} 0`)} class="svelte-bvo74f"><g${attr("transform", transform)} class="svelte-bvo74f">`;
    if (typeof i[4] == "string") {
      $$payload.out += "<!--[-->";
      $$payload.out += `<path${attr("d", i[4])}${attr("fill", color || primaryColor || "currentColor")}${attr("transform", `translate(${stringify(i[0] / -2)} ${stringify(i[1] / -2)})`)} class="svelte-bvo74f"></path>`;
    } else {
      $$payload.out += "<!--[!-->";
      $$payload.out += `<path${attr("d", i[4][0])}${attr("fill", secondaryColor || color || "currentColor")}${attr("fill-opacity", swapOpacity != false ? primaryOpacity : secondaryOpacity)}${attr("transform", `translate(${stringify(i[0] / -2)} ${stringify(i[1] / -2)})`)} class="svelte-bvo74f"></path><path${attr("d", i[4][1])}${attr("fill", primaryColor || color || "currentColor")}${attr("fill-opacity", swapOpacity != false ? secondaryOpacity : primaryOpacity)}${attr("transform", `translate(${stringify(i[0] / -2)} ${stringify(i[1] / -2)})`)} class="svelte-bvo74f"></path>`;
    }
    $$payload.out += `<!--]--></g></g></svg>`;
  } else {
    $$payload.out += "<!--[!-->";
  }
  $$payload.out += `<!--]-->`;
  bind_props($$props, {
    class: clazz,
    id,
    style,
    icon,
    title,
    size,
    color,
    fw,
    pull,
    scale,
    translateX,
    translateY,
    rotate,
    flip,
    spin,
    pulse,
    primaryColor,
    secondaryColor,
    primaryOpacity,
    secondaryOpacity,
    swapOpacity
  });
  pop();
}

export { Fa as F };
//# sourceMappingURL=fa-DW9dGsKW.js.map
